function y=ierfc(z,n)
% y=ierfc(z,n)
% repeated integral of complementary error function
% needed in transient 1D groundwater analysis
% TO 100222
%
if nargin<2, help('ierfc'); return; end
n=round(n);
if n<-1 
    error('second argument n must be integer >= -1');
end
switch n
    case -1
        y=2/sqrt(pi)*exp(-z.^2); return;
    case 0
        y=erfc(z); return;
    otherwise
        y=-z/n.*ierfc(z,n-1)+(1/2/n)*ierfc(z,n-2);
end
